/*

cvkbd.h - Colecovision Keyboard defines

*/

#define	KC_INIT	0       /* reset keyboard */
#define	KC_PEEK	1	/* peek next keycode */
#define	KC_NEXT	2	/* consume keycode */

#define	KD_ESC	27
#define	KD_BS	'\b'
#define	KD_TAB	'\t'
#define	KD_RET	'\r'
#define	KD_CBS	0x7f

#define	KD_F1	0xa0
#define	KD_F2	0xa1
#define	KD_F3	0xa2
#define	KD_F4	0xa3
#define	KD_F5	0xa4
#define	KD_F6	0xa5
#define	KD_F7	0xa6
#define	KD_F8	0xa7
#define	KD_F9	0xa8
#define	KD_F10	0xa9
#define	KD_F11	0xaa
#define	KD_F12	0xab

#define	KD_PSC	0xb0	/* PrtScn */
#define	KD_SCLK	0xb1	/* ScrollLock */
#define	KD_PAUS	0xb2	/* Pause */
#define	KD_HM	0xb3	/* Home */
#define	KD_ED	0xb4	/* End */
#define	KD_IN	0xb5	/* Insert */
#define	KD_DL	0xb6	/* Delete */
#define	KD_PU	0xb7	/* PageUp */
#define	KD_PD	0xb8	/* PageDown */
#define	KD_U	0xb9	/* Up */
#define	KD_D	0xba	/* Down */
#define	KD_L	0xbb	/* Left */
#define	KD_R	0xbc	/* Right */

#define	KD_NMLK	0xc0	/* NumLk */
#define	KD_NMDV	0xc1	/* Num/ */
#define	KD_NMT	0xc2	/* Num* */
#define	KD_NMM	0xc3	/* Num- */
#define	KD_NMHM	0xc4	/* NumHome */
#define	KD_NMU	0xc5	/* NumUp */
#define	KD_NMP	0xc6	/* Num+ */
#define	KD_NMPU	0xc7	/* NumPgUp */
#define	KD_NML	0xc8	/* NumLeft */
#define	KD_NMC	0xc9	/* NumMiddle */
#define	KD_NMR	0xca	/* NumRight */
#define	KD_NMED	0xcb	/* NumEnd */
#define	KD_NMD	0xcc	/* NumDown */
#define	KD_NMPD	0xcd	/* NumPgDn */
#define	KD_NMET	0xce	/* NumEnter */
#define	KD_NMIN	0xcf	/* NumIns */
#define	KD_NMDL	0xd0	/* NumDel */

#define	KD_LSH	0xd4	/* LeftShift */
#define	KD_RSH	0xd5	/* RightShift */
#define	KD_LCTL	0xd6	/* LeftCtrl */
#define	KD_RCTL	0xd7	/* RightCtrl */
#define	KD_LALT	0xd8	/* LeftAlt */
#define	KD_RALT	0xd9	/* RightAlt */
#define	KD_LWIN	0xda	/* LeftWindows */
#define	KD_RWIN	0xdb	/* RightWindows */
#define	KD_CAPL	0xdc	/* CapsLock */
#define	KD_MENU	0xdd	/* Menu */

#define	KD_POUN	0xe0	/* pound */

#define	KD_HI_Z	0xff	/* Nothing there */
#define	KD_INIT	0xfe	/* Initialise complete */
#define	KD_NEXT	0xfd	/* Keycode consumed */
#define	KD_PEEK	0xf8	/* All peeked data is lower than this */
#define	KD_NONE	0xf7	/* Peeking next keycode, but there is none */
#define	KD_RELE	0xf6	/* Release keycode */
#define	KD_UNKN	0xf5	/* Unknown scancode */
